#ifndef ZMODELER_STRUCT_VERTREF_H_INCLUDED
#define ZMODELER_STRUCT_VERTREF_H_INCLUDED

/////////////////////////////////////////////////////////////////////////////
//        SPLINES:  basic and custom;
/////////////////////////////////////////////////////////////////////////////

//Declaring type of list items
typedef tNormalVertex*  tNormVertListItem;

//Declaring type of list node
typedef struct tNormalVertexRef
{
  tNormVertListItem    Vert;
  tIndex          Index;
  tNormalVertexRef*    Next;
}tNormalVertexRef;

//Declaring type ListPointer
typedef tNormalVertexRef*  tNormVertList;


/********************************************
    Declaring tVertReference Class
********************************************/
class DllExport tVertReference: public tVertex
{
//----------------------------------
//  data members
  tNormVertList  Head;
  BOOL      DrawMode;
public:
  char      SplineName[MAX_OBJECT_NAMELENGTH];
  DWORD      Flags;
  void*      pCustomData;

  void*      pDeleteProc;
  void*      pUndoProc;


//----------------------------------
//  construction/deconstruction
  tVertReference();
  tVertReference(char* name, DWORD f, void* pCustomD, void* pDelProc, void* pUndoProc);
  ~tVertReference();

//----------------------------------
//  functions

  //returns a pointer to the vertex where the
  //edge, if it was clicked; (result and result->next is the edgex)
  //NULL if no matches.
  tNormVertListItem EdgeClick(
            POINT *loc,
            z3dViewDescriptor* pView);
  tNormVertListItem InsertAfter(  tNormVertListItem After, tNormVertListItem Item,
                  BOOL TempCreate);
  tNormVertListItem InsertAfter(  tNormVertListItem After, tPOINT p,
                  BOOL TempCreate);
  tNormVertListItem InsertBefore(  tNormVertListItem Before, tNormVertListItem Item,
                  BOOL TempCreate);
  tNormVertListItem InsertBefore(  tNormVertListItem Before, tPOINT p,
                  BOOL TempCreate);
  BOOL IsClosed();
  BOOL IsSingle();
  BOOL IsEmpty();
  tNormVertList GetLast();
  tNormVertList GetFirst();
  tNormVertList GetNode(tNormVertListItem Vertex);
  tNormVertList MakeReferenceDuplicate();
  int  GetAngle(tNormVertList  RefHead, z3dViewDescriptor* pView);
  BOOL CanExcludeSecond(tNormVertList  RefHead, z3dViewDescriptor* pView);
  BOOL SelfCrossing(tNormVertList  RefHead, z3dViewDescriptor* pView);
  
  void Reorient();
  void SetFirst(tNormVertList First);
  void AddVertex(tNormVertListItem Item, BOOL TempCreate, tIndex indx);
  void AddVertex(tPOINT p, BOOL TempCreate, tIndex indx);
  void AddVertex(float _x, float _y, float _z, BOOL TempCreate, tIndex indx);
  void MoveIntermediate(tPOINT *Offset);
  void MoveIntermediateOffset(tPOINT *Offset);
  tNormVertList PrepareToDelete(BOOL MarkedMode, BOOL Selection);
  
  void MarkUpAllVertices(BOOL MarkedMode, BOOL Selection);
  void EnableAllVerts();
  
  void DeleteList(tNormVertList StartFrom);
  void ExcludeVertex(tNormVertListItem Vert);
  void UnMarkList();
  void Indexate();
  void ResetIndexation();
  float GetReferenceLength();
  tIndex GetLastIndex();
  BOOL HasVertexIndex(tIndex indx);

  virtual void Draw(  CDC* pDC,
            z3dViewDescriptor* pView,
            BOOL DrawMarked);
  virtual BOOL Cover(  POINT *loc,
            z3dViewDescriptor* pView,
            long CoverRadius,
            tNormVertListItem* PutVert);
  BOOL Covered(    POINT *loc,
            z3dViewDescriptor* pView,
            long CoverRadius,
            tNormVertListItem* PutVert);
  /****************************************
        M O D I F E R S
  ****************************************/
  void Rotate (z3dViewDescriptor* pView, float Angle, BOOL MarkedMode, BOOL Selection,
      tPOINT& axis, tPOINT& base);
  void Mirror (BOOL bX, BOOL bY, BOOL bZ, BOOL MarkedMode, BOOL Selection);
  void MoveOffset (tPOINT *Offset, BOOL MarkedMode, BOOL Selection);
  void Scale(float XScale, float YScale, float ZScale, BOOL MarkedMode, BOOL Selection);
};


#endif

